

<?php $__env->startSection('title', 'Pharmacist Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-2 sm:px-4 lg:px-8">
    <h1 class="text-2xl sm:text-3xl font-bold text-gray-800 mb-4 sm:mb-6">Pharmacist Dashboard</h1>

    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-6 mb-6 sm:mb-8">
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-blue-100 rounded-full">
                    <i class="fas fa-calendar text-blue-600 text-2xl"></i>
                </div>
                <div class="ml-2 sm:ml-4">
                    <p class="text-xs sm:text-sm text-gray-600">Total Appointments</p>
                    <p class="text-xl sm:text-2xl font-bold"><?php echo e($stats['appointments']); ?></p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-yellow-100 rounded-full">
                    <i class="fas fa-clock text-yellow-600 text-2xl"></i>
                </div>
                <div class="ml-2 sm:ml-4">
                    <p class="text-xs sm:text-sm text-gray-600">Pending Appointments</p>
                    <p class="text-xl sm:text-2xl font-bold"><?php echo e($stats['pending_appointments']); ?></p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center">
                <div class="p-3 bg-green-100 rounded-full">
                    <i class="fas fa-users text-green-600 text-2xl"></i>
                </div>
                <div class="ml-2 sm:ml-4">
                    <p class="text-xs sm:text-sm text-gray-600">Total Patients</p>
                    <p class="text-xl sm:text-2xl font-bold"><?php echo e($stats['patients']); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Notifications Section -->
    <?php if(isset($notifications) && $notifications->count() > 0): ?>
    <div class="bg-white rounded-lg shadow p-4 sm:p-6 mb-4 sm:mb-6">
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-3 sm:mb-4 gap-2">
            <h2 class="text-lg sm:text-xl font-bold">Notifications</h2>
            <form method="POST" action="<?php echo e(route('pharmacist.notifications.mark-all-read')); ?>" class="inline">
                <?php echo csrf_field(); ?>
                <button type="submit" class="text-xs sm:text-sm text-blue-600 hover:text-blue-900">Mark all as read</button>
            </form>
        </div>
        <div class="space-y-3">
            <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="border-l-4 border-green-500 bg-green-50 p-4 rounded">
                <div class="flex justify-between items-start">
                    <div class="flex-1">
                        <div class="flex items-start gap-2">
                            <i class="fas fa-prescription text-green-600 mt-1"></i>
                            <div class="flex-1">
                                <p class="font-semibold text-gray-800 text-sm sm:text-base"><?php echo e($notification->data['message'] ?? 'New notification'); ?></p>
                                <?php if(isset($notification->data['prescription_id'])): ?>
                                    <div class="mt-2 text-xs sm:text-sm text-gray-600">
                                        <p><strong>Prescription #:</strong> <?php echo e($notification->data['prescription_number'] ?? 'N/A'); ?></p>
                                        <p><strong>Patient:</strong> <?php echo e($notification->data['patient_name'] ?? 'N/A'); ?></p>
                                    </div>
                                    <div class="mt-2">
                                        <a href="<?php echo e(route('prescriptions.show', $notification->data['prescription_id'])); ?>" class="text-xs sm:text-sm text-blue-600 hover:text-blue-900">
                                            <i class="fas fa-eye"></i> View Prescription
                                        </a>
                                    </div>
                                <?php endif; ?>
                                <p class="text-xs text-gray-500 mt-2"><?php echo e($notification->created_at->diffForHumans()); ?></p>
                            </div>
                        </div>
                    </div>
                    <form method="POST" action="<?php echo e(route('pharmacist.notifications.mark-read', $notification->id)); ?>" class="ml-4">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="text-gray-400 hover:text-gray-600">
                            <i class="fas fa-times"></i>
                        </button>
                    </form>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>

    <div class="mb-4 sm:mb-6 flex flex-col sm:flex-row gap-2 sm:space-x-4">
        <a href="<?php echo e(route('pharmacist.appointments.create')); ?>" class="bg-blue-600 hover:bg-blue-700 text-white px-4 sm:px-6 py-2 rounded text-sm sm:text-base text-center">
            Create New Appointment
        </a>
        <a href="<?php echo e(route('pharmacist.prescriptions')); ?>" class="bg-green-600 hover:bg-green-700 text-white px-4 sm:px-6 py-2 rounded text-sm sm:text-base text-center">
            View Prescriptions
        </a>
    </div>

    <div class="bg-white rounded-lg shadow p-4 sm:p-6">
        <h2 class="text-lg sm:text-xl font-bold mb-3 sm:mb-4">Recent Appointments</h2>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Patient</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden md:table-cell">Doctor</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $recentAppointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appointment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="text-sm sm:text-base"><?php echo e($appointment->patient->full_name); ?></span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden md:table-cell">
                            <span class="text-sm"><?php echo e($appointment->doctor ? $appointment->doctor->full_name : 'N/A'); ?></span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="text-xs sm:text-sm"><?php echo e($appointment->appointment_date->format('M d, Y H:i')); ?></span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="px-2 py-1 text-xs rounded-full bg-yellow-100 text-yellow-800">
                                <?php echo e(ucfirst($appointment->status)); ?>

                            </span>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/pharmacist/dashboard.blade.php ENDPATH**/ ?>